setwd("D:/experiment/Conference Paper/ICLR/ICLR 2025/code/table3")
rm(list = ls())
library(MASS)

library(gtools)

dpath          <- file.path("D:/experiment/Conference Paper/ICLR/ICLR 2025/Dataset/")  

d_index <- 1

Dataset       <- c("ailerons_all","bank_all","elevators_all","parkinsons","cpusmall","calhousing") 

savepath      <- paste0("D:/experiment/Conference Paper/ICLR/ICLR 2025/Result/",
                        paste0("Alg1-",Dataset[d_index],".txt"))

traindatapath    <- file.path(dpath, paste0(Dataset[d_index], ".train"))                
traindatamatrix  <- as.matrix(read.table(traindatapath))
trdata           <- traindatamatrix[ ,-1]
ylabel           <- traindatamatrix[ ,1]

length_tr        <- nrow(trdata)    
feature_tr       <- ncol(trdata)  

reptimes <- 10
b        <- 1
comb     <- combinations(feature_tr, b)
N        <- nrow(comb)
U        <- 1                ### U=0.1, 0.5,1
c        <- 500              ### c=0.1, 0.5,1, 5, 10, 50,100
Full_set <- 1:N
q_1      <- 2/(feature_tr*(feature_tr-1))
q_2      <- 2/feature_tr
eta      <- c*q_1*sqrt(log(feature_tr))/sqrt(length_tr)
lambda   <- c*q_1/sqrt(length_tr)

runtime   <- c(rep(0, reptimes))
errorrate <- c(rep(0, reptimes))

for(re in 1:reptimes)
{
  order    <- sample(1:length_tr,length_tr,replace = F)   #dis
  tilde_c  <- c(rep(0, N))
  p        <- c(rep(1/N, N))
  q        <- c(rep(1/feature_tr, feature_tr))
  delta_t  <- c(rep(0, feature_tr))
  w        <- matrix(0,nrow = N,ncol=feature_tr)
  error    <- 0
  
  t1    <- proc.time()                                     #proc.time()
  
  for (t in 1:length_tr)
  {
    X_t    <- matrix(0,nrow = feature_tr,ncol=feature_tr)
    xt     <- trdata[order[t],]
    It     <- sample(1:N, 1, replace=T,prob=p)
    sum    <- crossprod(w[It,],xt)[1,1]
    error  <- error + (sum-ylabel[order[t]])^2
    
    J1     <- sample(1:feature_tr, 1, replace=T,prob=q)
    q_     <- c(rep(1/(feature_tr-1), feature_tr))
    q_[J1] <- 0
    J2     <- sample(1:feature_tr, 1, replace=T,prob=q_)

    tilde_x     <- ylabel[order[t]]*delta_t
    tilde_x[J1] <- xt[J1]/q_2
    tilde_x[J2] <- xt[J2]/q_2
    
    X_t[J1,J1]  <- xt[J1]^2/q_2
    X_t[J2,J2]  <- xt[J2]^2/q_2
    X_t[J1,J2]  <- xt[J1]*xt[J2]/q_1
    X_t[J2,J1]  <- X_t[J1,J2]
    
    ################################## updating w_{t,i}
    for(i in 1:N)
    {
      tem           <- X_t%*%w[i,]
      tilde_c[i]    <- crossprod(w[i,],tem)[1,1]-2*crossprod(w[i,],tilde_x)[1,1]+ylabel[order[t]]^2
      
      nabla         <- 2*(tem[comb[i,]]-tilde_x[comb[i,]])
      w[i,comb[i,]] <- w[i,comb[i,]] - lambda*nabla
      Norm          <- sqrt(crossprod(w[i,],w[i,])[1,1])
      if(Norm >U)
      {
        w[i,]       <- w[i,]*U/Norm
      }
    }
  
    ######################################### updating p_t
    tilde_p         <- p*exp(-tilde_c*eta)
    p               <- tilde_p/sum(tilde_p)
  }
  
  t2 <- proc.time()
  runtime[re] <- (t2 - t1)[3]
  errorrate[re] <- error/length_tr
}

save_result <- list(
  note     = c(" the next term are:alg_name--dataname--run_time--tot_run_time--ave_run_time--err_num--all_err_rate--ave_err_rate--sd_time--sd_err"),
  alg_name = c("Alg1"),
  dataname = paste0(Dataset[d_index], ".train"),
  sam_num  = length_tr,
  U        = U,
  lambda = c,
  tot_run_time = sum(runtime),
  ave_run_time = sum(runtime)/reptimes,
  err_num  = errorrate,
  ave_err_rate = sum(errorrate)/reptimes,
  sd_time  <- sd(runtime),
  sd_err    <-sd(errorrate)
)
write.table(save_result,file=savepath,row.names =TRUE, col.names =FALSE, quote = T)

sprintf("the number of sample is %d", length_tr)
sprintf("total running time is %.1f in dataset", sum(runtime))
sprintf("average running time is %.1f in dataset", sum(runtime)/reptimes)
sprintf("the average MSE is %f", sum(errorrate)/reptimes)
sprintf("standard deviation of run_time is %.5f in dataset", sd(runtime))
sprintf("standard deviation of MSE is %.5f in dataset", sd(errorrate))
